<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class QualityCheck
 * @package App\Models
 * @version December 17, 2019, 3:48 am UTC
 *
 */
class QualityCheck extends CRUDAwareModel
{
    //use SoftDeletes;

    public $table = 'quality_checks';
    
   

    protected $dates = ['deleted_at'];


    public $fillable = [
        'material_id',
        'qty',
        'rejection_under_size_qty',
        'rejection_over_size_qty',
        'rejection_shape_qty',
        'net_qty',   
        'rejection_reason',
        'reason'     
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'qty' => 'float',
        'rejection_under_size_qty' => 'float',
        'rejection_over_size_qty'=> 'float',
        'rejection_shape_qty' => 'float',
        'net_qty' => 'float'
    ]; 

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'material_id' => 'required|exists:bond_material_recipes,material_id',
        'qty' => 'required|numeric',
        'rejection_under_size_qty' => 'nullable|numeric',
        'rejection_over_size_qty' => 'nullable|numeric',
        'rejection_shape_qty' => 'nullable|numeric',
    ];

    public static function getTotalProduction($materialId){
        $qty = \App\Models\QualityCheck::where('material_id','=',$materialId)->sum('net_qty');
        if(empty($qty)){
            return 0;
        }
        return $qty;
     }

     public static function getTotalProductionFreshQty($materialId){
        $qty = \App\Models\QualityCheck::where('material_id','=',$materialId)->sum('qty');
        if(empty($qty)){
            return 0;
        }
        return $qty;
     }

     public function material(){
        return $this->belongsTo('App\Models\BondMaterialRecipe','material_id');
     }
    
}
