<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

/**
 * Class Bond
 * @package App\Models
 * @version October 11, 2019, 7:53 pm UTC
 *
 * @property \Illuminate\Database\Eloquent\Collection userRoles
 * @property string bond_name
 * @property string bond_short_description
 * @property string phone
 * @property string username
 * @property string email
 * @property string password
 * @property string device_id
 * @property string location
 * @property string profile_path
 * @property string dob
 * @property string status
 */
class Bond extends CRUDAwareModel
{
    //use SoftDeletes;
    use HasTranslations;

    public $table = 'bonds';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'name',
        'bond_short_description',
        'bond_reference',
        'status',
        'size_spec',
        'piece_weight',
        'opening_stock',
        'qty_unit_id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'name' => 'string',
        'bond_short_description' => 'string',
        'piece_weight' => 'float',
        'opening_stock' => 'float'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required',
    ];

    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     **/
}
