<?php 

namespace App\Http\Resources\User;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\BaseJsonResource;
use App\Models\User;
use Log;

class UserResource extends BaseJsonResource
{
    public function toArray($request)
    {
        $roles = $this->getRoles();
        //Log::info('roles '.$roles);
        $permissions = $this->rolePermissions()->get();
        //Log::info('roles '.$permissions);
        $array = [
            'id' => $this->id,
            'username' => $this->username,
            'email' => $this->email,
            'phone' => $this->phone,
            'name' => $this->name,
            'address' => $this->address,
            'dob' => $this->dob,
            'status' => $this->status,
            'roles' => RoleResource::collection($roles),
            'permission' => PermissionResource::collection($permissions)    
        ];
        
        return $array;
    }

    
}