<?php 

namespace App\Http\Resources\Production;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Http\Resources\BaseJsonResource;
use App\Http\Resources\Bond\BondProcessResource;
use App\Http\Resources\Bond\BondProductResource;

class BondMaterialResource extends BaseJsonResource
{
    public function toArray($request)
    {
        $pcs = $this->expectedPcs();
        $currentStatus = \App\Models\BondRecipeProductionStatus::where('material_id','=', $this->material_id)->orderBy('created_at','DESC')->first();
        $array = [
            'material_id' => $this->material_id,
            'bond_product' => new \App\Http\Resources\Bond\BondProductResource($this->bondProduct),
            'weight' => $this->weight,
            'powder_cost' => $this->powder_cost,
            'priority' => $this->priority,
            'total_piece_packing' => $this->total_piece_packing,
            'finishing_setting' => new \App\Http\Resources\Consumable\ConsumableSettingResource($this->finishingSettings),
            'packing_setting' => new \App\Http\Resources\Consumable\ConsumableSettingResource($this->packingSettings),
            'binder_setting' => new \App\Http\Resources\Consumable\ConsumableSettingResource($this->bondProcessParam->findSetting('BINDER')),
            'expected_pcs' => $pcs,
            'expected_completion_time' => $this->expectedCompletionTime($pcs),
            'bond_process' => new BondProcessResource($this->bondProcessParam),
            'piece_per_mould' => $this->getPiecePerMould(),
            'status' => new ProductionStatusResource($currentStatus)            
        ];
        
        $array = $this->base($array);
        return $array;
    }
}