<?php 

namespace App\Http\Resources\Invoice;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Http\Resources\BaseJsonResource;

class InvoicePackingDetailResource extends BaseJsonResource
{
    public function toArray($request)
    {
        //dd($this->packingDetail);
        $array = [
            'packing' => new \App\Http\Resources\Packing\ProductionPackingResource($this->packingDetail),
            'unit_price' => $this->unit_price,
            'amount' => $this->amount,
            'cgst' => $this->hNull($this->cgst),
            'sgst' => $this->hNull($this->sgst),
            'igst' => $this->hNull($this->igst),
            'cgst_value' => $this->cgst_value,
            'igst_value' => $this->igst_value,
            'sgst_value' => $this->sgst_value,
            'net_gst' => $this->net_gst,
            'discount' => $this->hNull($this->discount),
            'discount_val' => $this->discount_val,
            'net_amount' => $this->net_amount
        ];
        $array = $this->base($array);
        
        return $array;
    }
}