<?php

namespace App\Http\Controllers;

use App\DataTables\EntryTagDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateEntryTagRequest;
use App\Http\Requests\UpdateEntryTagRequest;
use App\Repositories\EntryTagRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;

class EntryTagController extends AppBaseController
{
    /** @var  EntryTagRepository */
    private $entryTagRepository;

    public function __construct(EntryTagRepository $entryTagRepo)
    {
        $this->entryTagRepository = $entryTagRepo;
    }

    /**
     * Display a listing of the EntryTag.
     *
     * @param EntryTagDataTable $entryTagDataTable
     * @return Response
     */
    public function index(EntryTagDataTable $entryTagDataTable)
    {
        return $entryTagDataTable->render('entry_tags.index');
    }

    /**
     * Show the form for creating a new EntryTag.
     *
     * @return Response
     */
    public function create()
    {
        return view('entry_tags.create');
    }

    /**
     * Store a newly created EntryTag in storage.
     *
     * @param CreateEntryTagRequest $request
     *
     * @return Response
     */
    public function store(CreateEntryTagRequest $request)
    {
        $input = $request->all();

        $entryTag = $this->entryTagRepository->create($input);

        Flash::success('Entry Tag saved successfully.');

        return redirect(route('entryTags.index'));
    }

    /**
     * Display the specified EntryTag.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $entryTag = $this->entryTagRepository->find($id);

        if (empty($entryTag)) {
            Flash::error('Entry Tag not found');

            return redirect(route('entryTags.index'));
        }

        return view('entry_tags.show')->with('entryTag', $entryTag);
    }

    /**
     * Show the form for editing the specified EntryTag.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $entryTag = $this->entryTagRepository->find($id);

        if (empty($entryTag)) {
            Flash::error('Entry Tag not found');

            return redirect(route('entryTags.index'));
        }

        return view('entry_tags.edit')->with('entryTag', $entryTag);
    }

    /**
     * Update the specified EntryTag in storage.
     *
     * @param  int              $id
     * @param UpdateEntryTagRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateEntryTagRequest $request)
    {
        $entryTag = $this->entryTagRepository->find($id);

        if (empty($entryTag)) {
            Flash::error('Entry Tag not found');

            return redirect(route('entryTags.index'));
        }

        $entryTag = $this->entryTagRepository->update($request->all(), $id);

        Flash::success('Entry Tag updated successfully.');

        return redirect(route('entryTags.index'));
    }

    /**
     * Remove the specified EntryTag from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $entryTag = $this->entryTagRepository->find($id);

        if (empty($entryTag)) {
            Flash::error('Entry Tag not found');

            return redirect(route('entryTags.index'));
        }

        $this->entryTagRepository->delete($id);

        Flash::success('Entry Tag deleted successfully.');

        return redirect(route('entryTags.index'));
    }
}
