<?php

namespace App\Http\Controllers;

use App\DataTables\ConsumableItemDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateConsumableItemRequest;
use App\Http\Requests\UpdateConsumableItemRequest;
use App\Repositories\ConsumableItemRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;

class ConsumableItemController extends AppBaseController
{
    /** @var  ConsumableItemRepository */
    private $consumableItemRepository;

    public function __construct(ConsumableItemRepository $consumableItemRepo)
    {
        $this->consumableItemRepository = $consumableItemRepo;
    }

    /**
     * Display a listing of the ConsumableItem.
     *
     * @param ConsumableItemDataTable $consumableItemDataTable
     * @return Response
     */
    public function index(ConsumableItemDataTable $consumableItemDataTable)
    {
        return $consumableItemDataTable->render('consumable_items.index');
    }

    /**
     * Show the form for creating a new ConsumableItem.
     *
     * @return Response
     */
    public function create()
    {
        return view('consumable_items.create');
    }

    /**
     * Store a newly created ConsumableItem in storage.
     *
     * @param CreateConsumableItemRequest $request
     *
     * @return Response
     */
    public function store(CreateConsumableItemRequest $request)
    {
        $input = $request->all();

        $consumableItem = $this->consumableItemRepository->create($input);

        Flash::success('Consumable Item saved successfully.');

        return redirect(route('consumableItems.index'));
    }

    /**
     * Display the specified ConsumableItem.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $consumableItem = $this->consumableItemRepository->find($id);

        if (empty($consumableItem)) {
            Flash::error('Consumable Item not found');

            return redirect(route('consumableItems.index'));
        }

        return view('consumable_items.show')->with('consumableItem', $consumableItem);
    }

    /**
     * Show the form for editing the specified ConsumableItem.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $consumableItem = $this->consumableItemRepository->find($id);

        if (empty($consumableItem)) {
            Flash::error('Consumable Item not found');

            return redirect(route('consumableItems.index'));
        }

        return view('consumable_items.edit')->with('consumableItem', $consumableItem);
    }

    /**
     * Update the specified ConsumableItem in storage.
     *
     * @param  int              $id
     * @param UpdateConsumableItemRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateConsumableItemRequest $request)
    {
        $consumableItem = $this->consumableItemRepository->find($id);

        if (empty($consumableItem)) {
            Flash::error('Consumable Item not found');

            return redirect(route('consumableItems.index'));
        }

        $consumableItem = $this->consumableItemRepository->update($request->all(), $id);

        Flash::success('Consumable Item updated successfully.');

        return redirect(route('consumableItems.index'));
    }

    /**
     * Remove the specified ConsumableItem from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $consumableItem = $this->consumableItemRepository->find($id);

        if (empty($consumableItem)) {
            Flash::error('Consumable Item not found');

            return redirect(route('consumableItems.index'));
        }

        $this->consumableItemRepository->delete($id);

        Flash::success('Consumable Item deleted successfully.');

        return redirect(route('consumableItems.index'));
    }
}
