<?php

namespace App\Http\Controllers;

use InfyOm\Generator\Utils\ResponseUtil;
use Response;

/**
 * @SWG\Swagger(
 *   basePath="/api/v1",
 *   @SWG\Info(
 *     title="Laravel Generator APIs",
 *     version="1.0.0",
 *   )
 * )
 * This class should be parent class for other API controllers
 * Class AppBaseController
 */
class AppBaseController extends Controller
{
    public function sendError($error, $code = 404)
    {
        return Response::json(ResponseUtil::makeError($error), $code);
    }

    public function sendTableError($error, $code = 404)
    {
        return Response::json(["message" => $errors, "errors" => $error], $code);
    }
    public function sendResponse($data, $message)
    {
        return Response::json([
            'message' => $message,
            'data' => $data
        ]);
    }

    public function sendResponseMessage($message)
    {
        return Response::json([
            'message' => $message
        ]);
    }

    public function sendJSON($message)
    {
        return Response::json($message);
    }

    public function sendTwoHundredErrorResponse($message)
    {
        return Response::json([
            'success' => false,
            'message' => $message,
        ]);
    }

    public function sendDataResponse($resource)
    {
        return Response::json($resource);
    }

    public function sendEmptyDataResponse()
    {
        return Response::json(["data" => array()]);
    }

    public function sendValidationError($message, $errors =null){
        if($errors){
            return Response::json([
                'message' => $message,
                'errors' => $errors
            ], 422);
        }

        return Response::json([
            'message' => $message
        ], 422);
        
    }

    

}
