<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntryTypesTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('entry_types', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('label');
            $table->unsignedBigInteger('tag_id');
            $table->string('description');
            $table->integer('base_type')->default(0);
            $table->integer('numbering')->default(1);
            $table->string('prefix');
            $table->string('suffix');
            $table->integer('zero_padding')->default(0);
            $table->integer('restriction_bankcash')->default(1);

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('entry_types');
    }
}
