<?php 

namespace App\Http\Resources\Production;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Http\Resources\BaseJsonResource;
use App\Http\Resources\Packing\ProductionPackingDetailResource;


class BondMaterialFullResource extends BaseJsonResource
{
    public function toArray($request)
    {
        $recipe = \App\Models\BondMaterialRecipe::find($this->materialId);
        $production = \App\Models\BondRecipeProduction::where('material_id', '=', $this->materialId)->orderBy('created_at', 'DESC')->get();
        $qualityCheck = \App\Models\QualityCheck::where('material_id', '=', $this->materialId)->orderBy('created_at', 'DESC')->get();
        $packings = \App\Models\ProductionPackagingDetail::where('material_id', '=', $this->materialId)->orderBy('created_at', 'DESC')->get();
        $array = [
            'material_detail' => new BondMaterialResource($recipe),
            'production_detail' => BondMaterialProductionResource::collection($production),
            'quality_check' => QualityCheckResource::collection($qualityCheck),
            'packing_detail' => ProductionPackingDetailResource::collection($packings)
            //'status' => $this->getProductionStatus->status
        ];
        
        //  $array = $this->base($array);
        return $array;
    }
}