<?php

namespace App\Http\Controllers;

use App\DataTables\EntryTypeDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateEntryTypeRequest;
use App\Http\Requests\UpdateEntryTypeRequest;
use App\Repositories\EntryTypeRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;

class EntryTypeController extends AppBaseController
{
    /** @var  EntryTypeRepository */
    private $entryTypeRepository;

    public function __construct(EntryTypeRepository $entryTypeRepo)
    {
        $this->entryTypeRepository = $entryTypeRepo;
    }

    /**
     * Display a listing of the EntryType.
     *
     * @param EntryTypeDataTable $entryTypeDataTable
     * @return Response
     */
    public function index(EntryTypeDataTable $entryTypeDataTable)
    {
        return $entryTypeDataTable->render('entry_types.index');
    }

    /**
     * Show the form for creating a new EntryType.
     *
     * @return Response
     */
    public function create()
    {
        return view('entry_types.create');
    }

    /**
     * Store a newly created EntryType in storage.
     *
     * @param CreateEntryTypeRequest $request
     *
     * @return Response
     */
    public function store(CreateEntryTypeRequest $request)
    {
        $input = $request->all();

        $entryType = $this->entryTypeRepository->create($input);

        Flash::success('Entry Type saved successfully.');

        return redirect(route('entryTypes.index'));
    }

    /**
     * Display the specified EntryType.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $entryType = $this->entryTypeRepository->find($id);

        if (empty($entryType)) {
            Flash::error('Entry Type not found');

            return redirect(route('entryTypes.index'));
        }

        return view('entry_types.show')->with('entryType', $entryType);
    }

    /**
     * Show the form for editing the specified EntryType.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $entryType = $this->entryTypeRepository->find($id);

        if (empty($entryType)) {
            Flash::error('Entry Type not found');

            return redirect(route('entryTypes.index'));
        }

        return view('entry_types.edit')->with('entryType', $entryType);
    }

    /**
     * Update the specified EntryType in storage.
     *
     * @param  int              $id
     * @param UpdateEntryTypeRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateEntryTypeRequest $request)
    {
        $entryType = $this->entryTypeRepository->find($id);

        if (empty($entryType)) {
            Flash::error('Entry Type not found');

            return redirect(route('entryTypes.index'));
        }

        $entryType = $this->entryTypeRepository->update($request->all(), $id);

        Flash::success('Entry Type updated successfully.');

        return redirect(route('entryTypes.index'));
    }

    /**
     * Remove the specified EntryType from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $entryType = $this->entryTypeRepository->find($id);

        if (empty($entryType)) {
            Flash::error('Entry Type not found');

            return redirect(route('entryTypes.index'));
        }

        $this->entryTypeRepository->delete($id);

        Flash::success('Entry Type deleted successfully.');

        return redirect(route('entryTypes.index'));
    }
}
