<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Log;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;
use App\Support\Google2FAAuthenticator;
use Illuminate\Support\Facades\Auth;

class MobileTokenController extends Controller
{


protected function redirectAuth(\Illuminate\Http\Request $request)
{
    $request->session()->put('state', $state = Str::random(40));
    //$request->session()->put('source', 'mobile');
    Log::info('redirecting Auth');
    $query = http_build_query([
        'client_id' => 1,
        'redirect_uri' => url('callback'),
        'response_type' => 'code',
        'scope' => '*',
        'state' => $state,
    ]);

    return redirect(url('oauth/authorize?'.$query));
}

protected function callbackAuth(\Illuminate\Http\Request $request)
{
    //$http = \App\Utils\Util::getClient();
    //Log::info('callbackAuth');
    //Log::info(' code '.$request->get('code'));
    $code = $request->get('code');
        if(!empty($code)){
            return \App\Helpers\CommHelper::doTokenRequest($code);
        }
    //$authenticator = app(Google2FAAuthenticator::class)->boot($request);
    // if(!$authenticator->isAuthenticated()){
    //     $code = $request->get('code');
    //     if(!empty($code)){
    //         return \App\Helpers\CommHelper::doTokenRequest($code);
    //     }
    // }else{
    //     //$request->request->remove('code');
    //     return "Unauthorized";
    // }
        

    // $request->session()->put('code', $request->get('code'));
    // $request->session()->put('id', $user->id);
    // return $authenticator->makeRequestOneTimePasswordResponse(); 
}

}
