<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;

/**
 * Class ConsumableConsumpation
 * @package App\Models
 * @version December 19, 2019, 4:40 am UTC
 *
 */
class ConsumableConsumpation extends Model
{
    //use SoftDeletes;

    public $table = 'consumable_consumpations';
    

    protected $dates = ['deleted_at','created_at'];


    public $fillable = [
        'name',
        'change_date',
        'narration',
        'created_by',
        'change_reason'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required',
        'change_date' => 'required|date|date_format:d-m-Y g:i a',
        'change_reason' => 'required'
    ];

    public function getChangeDateAttribute() {
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->attributes['change_date'])->format('d-m-Y g:i a');
    }
    
      public function setChangeDateAttribute($value) {
        $this->attributes['change_date'] = Carbon::createFromFormat('d-m-Y g:i a', $value)->format('Y-m-d H:i:s');
      }

      public function consumptionDetail(){
        return ConsumableConsumpationDetail::where('consumpation_id','=', $this->id)->orderBy('created_at', 'DESC')->get();
      }
    
}
