<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Account;
use Log;

class UpdateAccountRequest extends FormRequest
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
       // Log::info('segment3 '.$this->segment(3).'  segment 4'.$this->segment(4));
        if(is_numeric($this->segment(3))){
           // Log::info('segment3 '.'  segment 3'.$this->segment(3));
            Account::$rules['name'] = 'required|unique:accounts,name,'.$this->segment(3).',id';
        }else{
            //Log::info('  segment 5'.$this->segment(5));
            Account::$rules['name'] = 'required|unique:accounts,name,'.$this->segment(5).',id';
        }
        
        return Account::$rules;
    }
}
