<?php

namespace App\Http\Controllers;

use App\DataTables\BondDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateBondRequest;
use App\Http\Requests\UpdateBondRequest;
use App\Repositories\BondRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;

class BondController extends AppBaseController
{
    /** @var  BondRepository */
    private $bondRepository;

    public function __construct(BondRepository $bondRepo)
    {
        $this->bondRepository = $bondRepo;
    }

    /**
     * Display a listing of the Bond.
     *
     * @param BondDataTable $bondDataTable
     * @return Response
     */
    public function index(BondDataTable $bondDataTable)
    {
        return $bondDataTable->render('bonds.index');
    }

    /**
     * Show the form for creating a new Bond.
     *
     * @return Response
     */
    public function create()
    {
        return view('bonds.create');
    }

    /**
     * Store a newly created Bond in storage.
     *
     * @param CreateBondRequest $request
     *
     * @return Response
     */
    public function store(CreateBondRequest $request)
    {
        $input = $request->all();
        
        $bond = $this->bondRepository->create($input);

        Flash::success('Bond saved successfully.');

        return redirect(route('bonds.index'));
    }

    /**
     * Display the specified Bond.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $bond = $this->bondRepository->find($id);

        if (empty($bond)) {
            Flash::error('Bond not found');

            return redirect(route('bonds.index'));
        }

        return view('bonds.show')->with('bond', $bond);
    }

    /**
     * Show the form for editing the specified Bond.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $bond = $this->bondRepository->find($id);

        if (empty($bond)) {
            Flash::error('Bond not found');

            return redirect(route('bonds.index'));
        }

        return view('bonds.edit')->with('bond', $bond);
    }

    /**
     * Update the specified Bond in storage.
     *
     * @param  int              $id
     * @param UpdateBondRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateBondRequest $request)
    {
        $bond = $this->bondRepository->find($id);

        if (empty($bond)) {
            Flash::error('Bond not found');

            return redirect(route('bonds.index'));
        }

        $input = $request->all();
    
        $bond = $this->bondRepository->update($input, $id);

        Flash::success('Bond updated successfully.');

        return redirect(route('bonds.index'));
    }

    /**
     * Remove the specified Bond from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $bond = $this->bondRepository->find($id);

        if (empty($bond)) {
            Flash::error('Bond not found');

            return redirect(route('bonds.index'));
        }

        $this->bondRepository->delete($id);

        Flash::success('Bond deleted successfully.');

        return redirect(route('bonds.index'));
    }
}
