<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBondProcessParamsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bond_process_params', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->enum('proc_type', CreateUsersTable::f(config('app_data.proc_type_enum')));    
            $table->json('mixing_detail')->nullable(true);
            $table->json('hotpress_detail')->nullable(true);
            $table->json('finishing_detail')->nullable(true);

            $table->json('other_detail')->nullable(true);

            $table->decimal('cycle_time', 25, 2)->nullable(true);

            $table->decimal('expected_mould', 25, 2)->nullable(true);

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            //$table->unsignedBigInteger('deleted_by')->nullable();
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');
            //$table->foreign('deleted_by')->references('id')->on('users');
            
            $table->timestamps();
           // $table->softDeletes();
            
        });

        

        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('bond_process_params');
    }
}
