<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;
use Carbon\Carbon;


/**
 * Class BondRecipeProduction
 * @package App\Models
 * @version October 11, 2019, 10:16 pm UTC
 *
 */
class BondRecipeProduction extends CRUDAwareModel
{
    //use SoftDeletes;
    use HasTranslations;

    public $table = 'bond_recipe_productions';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'material_id',
        'start_time',
        'end_time',
        'duration',
        'electricity_out_duration',
        'other_blocker_reason',
        'other_prod_blocker_duration',
        'remaining_piece',
        'mould',
        'reason',
        'narration',
        'employee_id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'start_time' => 'datetime',
        'end_time' => 'datetime',
        "mould" => 'ineteger',
        "remaining_piece" => 'inetger',
        "electricity_out_duration" => "float",
        "other_prod_blocker_duration" => "float"
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'material_id' => 'required|exists:bond_material_recipes,material_id',
        'start_time' => 'required|date|date_format:d-m-Y g:i a',
        'end_time' => 'required|date|date_format:d-m-Y g:i a',
        'mould' => 'required|numeric',
        'remaining_piece' => 'nullable|numeric',
        'electricity_out_duration' => 'nullable|numeric',
        'other_prod_blocker_duration' => 'nullable|numeric',
        'other_blocker_reason' => 'required_with:other_prod_blocker_duration'
    ];

    public function getStartTimeAttribute() {
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->attributes['start_time'])->format('d-m-Y g:i a');
    }
    
      public function setStartTimeAttribute($value) {
        $this->attributes['start_time'] = Carbon::createFromFormat('d-m-Y g:i a', $value)->format('Y-m-d H:i:s');
      }

      public function getEndTimeAttribute() {
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->attributes['end_time'])->format('d-m-Y g:i a');
      }
    
      public function setEndTimeAttribute($value) {
        $this->attributes['end_time'] = Carbon::createFromFormat('d-m-Y g:i a', $value)->format('Y-m-d H:i:s');
      }

      public static function getTotalMould($materialId){
         $mould = \App\Models\BondRecipeProduction::where('material_id','=',$materialId)->sum('mould');
         if(empty($mould)){
            return 0;
        }
        return $mould;
      }

      public static function getTotalRemainingPiece($materialId){
        $remainingPiece = \App\Models\BondRecipeProduction::where('material_id','=',$materialId)->sum('remaining_piece');
        if(empty($remainingPiece)){
            return 0;
        }
        return $remainingPiece;
      }


      public function material(){
        return $this->belongsTo('App\Models\BondMaterialRecipe','material_id');
      }


      public function employee(){
        return $this->belongsTo('App\Models\Employee','employee_id');
      }

      

    
}
