<?php 

namespace App\Http\Resources\Packing;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Http\Resources\BaseJsonResource;

class ProductionPackingResource extends BaseJsonResource
{
    public function toArray($request)
    {

        $bondData = \App\Models\ProductionPackaging::getBondData($this->packing_id);

        $array = [
            'packing_id' => $this->packing_id,
            'qty' => (float)$this->qty,
            'narration' => $this->narration,
            'product_name' => $bondData->product_name,
            'bond_name' => $bondData->bond_name,
            'size' => $bondData->size,
            'product_desc' =>$bondData->product_desc,
            'unit' => $bondData->unit,
            'weight' => $this->weight,
            'items' => ProductionPackingDetailResource::collection($this->packingDetail()) 
        ];
        
        $array = $this->base($array);
        return $array;
    }
}