<?php 

namespace App\Http\Resources\Invoice;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Http\Resources\BaseJsonResource;

class InvoiceResource extends BaseJsonResource
{
    public function toArray($request)
    {
        //dd($this->pendingInvoiceDetail);

        $array = [
            'id' => $this->id,
            'invoice_date' => $this->invoice_date,
            'account' => new \App\Http\Resources\Account\AccountResource($this->account),
            'invoice_number' => $this->invoice_number,
            'narration' => $this->narration,
            'invoice_type' => $this->invoice_type,
            'ref_number' => $this->ref_number,
            'invoice_final_date' => $this->invoice_final_date,
            'cgst' => $this->hNull($this->cgst),
            'sgst' => $this->hNull($this->sgst),
            'igst' => $this->hNull($this->igst),
            'cgst_value' => $this->cgst_value,
            'sgst_value' => $this->cgst_value,
            'igst_value' => $this->igst_value,
            'net_gst' => $this->net_gst,
            'taxable_amount' => $this->taxable_amount,
            'discount' => $this->hNull($this->discount),
            'transport' => $this->hNull($this->transport),
            'packing_charge' => $this->hNull($this->packing_charge),
            'billedAmount' => $this->billedAmount,
            'totalAmount' => $this->totalAmount,
            'packing_detail' => InvoicePackingDetailResource::collection($this->pendingInvoiceDetail),
            'consumable_detail' => InvoiceConsumableDetailResource::collection($this->consumableInvoiceDetail),
            'eway_bill_no' => $this->eway_bill_no,
            'transport_number' => $this->transport_number,
            'tracking_number' => $this->tracking_number,
            'place_of_supply' => $this->place_of_supply,

        ];

        $array = $this->base($array);
        
        return $array;
    }
}