<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\ConsumableCategory;

class UpdateConsumableCategoryRequest extends FormRequest
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        ConsumableCategory::$updateRules['name.en'] = ['required',function ($attribute, $value, $fail) {
            $model = ConsumableCategory::where([
            ['name->en','=',$this->input('name.en')]])->whereNotIn('id',[$this->segment(3)])->first();
            if (!empty($model)) {
                $fail($attribute.' is already exists');
            }
        }];
   
        ConsumableCategory::$updateRules['name.hi'] = ['required',function ($attribute, $value, $fail) {
           $model = ConsumableCategory::where([
           ['name->hi','=',$this->input('name.hi')]])->whereNotIn('id',[$this->segment(3)])->first();
           if (!empty($model)) {
               $fail($attribute.' is already exists');
           }
       }];

        return ConsumableCategory::$updateRules;
    }
}
