<?php

namespace App\Http\Controllers;

use App\DataTables\EntryDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateEntryRequest;
use App\Http\Requests\UpdateEntryRequest;
use App\Repositories\EntryRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;

class EntryController extends AppBaseController
{
    /** @var  EntryRepository */
    private $entryRepository;

    public function __construct(EntryRepository $entryRepo)
    {
        $this->entryRepository = $entryRepo;
    }

    /**
     * Display a listing of the Entry.
     *
     * @param EntryDataTable $entryDataTable
     * @return Response
     */
    public function index(EntryDataTable $entryDataTable)
    {
        return $entryDataTable->render('entries.index');
    }

    /**
     * Show the form for creating a new Entry.
     *
     * @return Response
     */
    public function create()
    {
        return view('entries.create');
    }

    /**
     * Store a newly created Entry in storage.
     *
     * @param CreateEntryRequest $request
     *
     * @return Response
     */
    public function store(CreateEntryRequest $request)
    {
        $input = $request->all();

        $entry = $this->entryRepository->create($input);

        Flash::success('Entry saved successfully.');

        return redirect(route('entries.index'));
    }

    /**
     * Display the specified Entry.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $entry = $this->entryRepository->find($id);

        if (empty($entry)) {
            Flash::error('Entry not found');

            return redirect(route('entries.index'));
        }

        return view('entries.show')->with('entry', $entry);
    }

    /**
     * Show the form for editing the specified Entry.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $entry = $this->entryRepository->find($id);

        if (empty($entry)) {
            Flash::error('Entry not found');

            return redirect(route('entries.index'));
        }

        return view('entries.edit')->with('entry', $entry);
    }

    /**
     * Update the specified Entry in storage.
     *
     * @param  int              $id
     * @param UpdateEntryRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateEntryRequest $request)
    {
        $entry = $this->entryRepository->find($id);

        if (empty($entry)) {
            Flash::error('Entry not found');

            return redirect(route('entries.index'));
        }

        $entry = $this->entryRepository->update($request->all(), $id);

        Flash::success('Entry updated successfully.');

        return redirect(route('entries.index'));
    }

    /**
     * Remove the specified Entry from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $entry = $this->entryRepository->find($id);

        if (empty($entry)) {
            Flash::error('Entry not found');

            return redirect(route('entries.index'));
        }

        $this->entryRepository->delete($id);

        Flash::success('Entry deleted successfully.');

        return redirect(route('entries.index'));
    }
}
