<?php

namespace App\Http\Controllers;

use App\DataTables\BondDesignDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateBondDesignRequest;
use App\Http\Requests\UpdateBondDesignRequest;
use App\Repositories\BondDesignRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;
use Log;

class BondDesignController extends AppBaseController
{
    /** @var  BondDesignRepository */
    private $bondDesignRepository;

    public function __construct(BondDesignRepository $bondDesignRepo)
    {
        $this->bondDesignRepository = $bondDesignRepo;
    }

    /**
     * Display a listing of the BondDesign.
     *
     * @param BondDesignDataTable $bondDesignDataTable
     * @return Response
     */
    public function index(BondDesignDataTable $bondDesignDataTable)
    {
        return $bondDesignDataTable->render('bond_designs.index');
    }

    /**
     * Show the form for creating a new BondDesign.
     *
     * @return Response
     */
    public function create()
    {
        return view('bond_designs.create');
    }

    /**
     * Store a newly created BondDesign in storage.
     *
     * @param CreateBondDesignRequest $request
     *
     * @return Response
     */
    public function store(CreateBondDesignRequest $request)
    {
        $input = $request->all();
        $this->filterData($input);
       
        $bondDesign = $this->bondDesignRepository->create($input);

        Flash::success('Bond Design saved successfully.');

        return redirect(route('bondDesigns.index'));
    }

    /**
     * Display the specified BondDesign.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $bondDesign = $this->bondDesignRepository->find($id);

        if (empty($bondDesign)) {
            Flash::error('Bond Design not found');

            return redirect(route('bondDesigns.index'));
        }

        return view('bond_designs.show')->with('bondDesign', $bondDesign);
    }

    /**
     * Show the form for editing the specified BondDesign.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $bondDesign = $this->bondDesignRepository->find($id);

        if (empty($bondDesign)) {
            Flash::error('Bond Design not found');

            return redirect(route('bondDesigns.index'));
        }

        return view('bond_designs.edit')->with('bondDesign', $bondDesign);
    }

    private function filterData(& $input){
        $input['consumable_setting_1'] = $input['consumable_setting_id_1'];
        $input['consumable_setting_2'] = $input['consumable_setting_id_2'];
        $input['weight1_average'] = ((float)$input['weight1_lower']+(float)$input['weight1_upper'])/2;
        $input['weight2_average'] = ((float)$input['weight2_lower']+(float)$input['weight2_upper'])/2;
        $input['piece_net_weight'] = ($input['weight1_average']*$input['weight1_nos'])+ ($input['weight2_average']*$input['weight2_nos']);  
        Log::info('piece net weight '.$input['piece_net_weight']);
    }
    /**
     * Update the specified BondDesign in storage.
     *
     * @param  int              $id
     * @param UpdateBondDesignRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateBondDesignRequest $request)
    {
        $bondDesign = $this->bondDesignRepository->find($id);

        if (empty($bondDesign)) {
            Flash::error('Bond Design not found');

            return redirect(route('bondDesigns.index'));
        }

       
        $input = $request->all();    
        $this->filterData($input);
        
        $bondDesign = $this->bondDesignRepository->update($input, $id);

        Flash::success('Bond Design updated successfully.');

        return redirect(route('bondDesigns.index'));
    }

    /**
     * Remove the specified BondDesign from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $bondDesign = $this->bondDesignRepository->find($id);

        if (empty($bondDesign)) {
            Flash::error('Bond Design not found');

            return redirect(route('bondDesigns.index'));
        }

        $this->bondDesignRepository->delete($id);

        Flash::success('Bond Design deleted successfully.');

        return redirect(route('bondDesigns.index'));
    }
}
