/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.part;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.part.PartComponentManager;
import net.sf.jasperreports.engine.part.PartComponentsBundle;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PartComponentsEnvironment {
    private static final Log log = LogFactory.getLog(PartComponentsEnvironment.class);
    public static final String EXCEPTION_MESSAGE_KEY_PART_COMPONENTS_BUNDLE_NOT_REGISTERED = "engine.part.components.bundle.not.registered";
    private final ReferenceMap cache = new ReferenceMap(2, 0);
    private JasperReportsContext jasperReportsContext;

    private PartComponentsEnvironment(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static PartComponentsEnvironment getInstance(JasperReportsContext jasperReportsContext) {
        return new PartComponentsEnvironment(jasperReportsContext);
    }

    public Collection<PartComponentsBundle> getBundles() {
        Map<String, PartComponentsBundle> components = this.getCachedBundles();
        return components.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, PartComponentsBundle> getCachedBundles() {
        Object cacheKey = ExtensionsEnvironment.getExtensionsCacheKey();
        ReferenceMap referenceMap = this.cache;
        synchronized (referenceMap) {
            Map<String, PartComponentsBundle> components = (Map<String, PartComponentsBundle>)this.cache.get(cacheKey);
            if (components == null) {
                components = this.findBundles();
                this.cache.put(cacheKey, components);
            }
            return components;
        }
    }

    protected Map<String, PartComponentsBundle> findBundles() {
        HashMap<String, PartComponentsBundle> components = new HashMap<String, PartComponentsBundle>();
        List<PartComponentsBundle> bundles = this.jasperReportsContext.getExtensions(PartComponentsBundle.class);
        for (PartComponentsBundle bundle : bundles) {
            String namespace = bundle.getXmlParser().getNamespace();
            if (components.containsKey(namespace)) {
                log.warn((Object)("Found two components for namespace " + namespace));
                continue;
            }
            components.put(namespace, bundle);
        }
        return components;
    }

    public PartComponentsBundle getBundle(String namespace) {
        Map<String, PartComponentsBundle> components = this.getCachedBundles();
        PartComponentsBundle componentsBundle = components.get(namespace);
        if (componentsBundle == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_PART_COMPONENTS_BUNDLE_NOT_REGISTERED, new Object[]{namespace});
        }
        return componentsBundle;
    }

    public PartComponentManager getManager(ComponentKey componentKey) {
        String namespace = componentKey.getNamespace();
        PartComponentsBundle componentsBundle = this.getBundle(namespace);
        String name = componentKey.getName();
        return componentsBundle.getComponentManager(name);
    }
}

