<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;

/**
 * Class BondInvoice
 * @package App\Models
 * @version November 26, 2019, 4:31 am UTC
 *
 */
class Invoice extends CRUDAwareModel
{
    //use SoftDeletes;

    public $table = 'invoices';
    

   // protected $dates = ['deleted_at'];


    public $fillable = [
        'invoice_date',
        'account_id',
        'invoice_number',
        'narration',
        'ref_number',
        'invoice_type',
        'cgst',
        'sgst',
        'igst',
        'cgst_value',
        'sgst_value',
        'igst_value',
        'net_gst',
        'taxable_amount',
        'discount',
        'transport',
        'packing_charge',
        'billedAmount',
        'totalAmount',
        'created_by',
        'updated_by'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        "cgst" => "float",
        "sgst" => "float",
        "igst" => "float",
        "cgst_value" => "float",
        "sgst_value" => "float",
        "igst_value" => "float",
        'net_gst' => 'float',
        'taxable_amount' => 'float',
        'discount' => 'float',
        'transport' => 'float',
        'billedAmount' => 'float',
        'totalAmount' => 'float'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        
    ];

    public function account(){
        return $this->belongsTo('App\Models\Account','account_id');
    }

    public function pendingInvoiceDetail(){
        return $this->hasMany('App\Models\BondInvoiceDetail', 'invoice_id');
    }

    public function consumableInvoiceDetail(){
        return $this->hasMany('App\Models\InvoiceConsumableDetail', 'invoice_id');
    }

    public static function generateInvoiceNumber($date){
        $date = Carbon::createFromFormat('d-m-Y', $date)->format('Y/m/d');
        $invoice = Invoice::orderBy('id','DESC')->first();
        if(empty($invoice)){
            return $date.'-1';
        }
        return $date.'-'.($invoice->id+1);
    }

    public function getInvoiceDateAttribute() {
        return Carbon::createFromFormat('Y-m-d', $this->attributes['invoice_date'])->format('d-m-Y');
    }
    
      public function setInvoiceDateAttribute($value) {
          if(!isset($value)){
            $this->attributes['invoice_date']=null;      
          }
        $this->attributes['invoice_date'] = Carbon::createFromFormat('d-m-Y', $value)->format('Y-m-d');
      }

      public function getInvoiceFinalDateAttribute() {
        if(!isset($this->attributes['invoice_final_date'])){
            return null;
        }
        return Carbon::createFromFormat('Y-m-d', $this->attributes['invoice_final_date'])->format('d-m-Y');
    }
    
      public function setInvoiceFinalDateAttribute($value) {
        $this->attributes['invoice_final_date'] = Carbon::createFromFormat('d-m-Y', $value)->format('Y-m-d');
      }
    
}
