<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Auth::routes();

Route::get('captcha-handler', '\LaravelCaptcha\Controllers\CaptchaHandlerController@index');
Route::get('simple-captcha-handler', '\LaravelCaptcha\Controllers\SimpleCaptchaHandlerController@index');


Route::get('/auth/redirect', 'Auth\MobileTokenController@redirectAuth');

Route::get('/callback', 'Auth\MobileTokenController@callbackAuth')->middleware(['auth', '2fa']);;

Route::group(['prefix' => '', 'middleware' => 'auth'], function(){  
    Route::get('/handleLogin', 'Auth\LoginController@handleAfterLogin');
    Route::get('/2fa','PasswordSecurityController@show2faForm');
    Route::post('/generate2faSecret','PasswordSecurityController@generate2faSecret')->name('generate2faSecret');
    Route::post('/2fa','PasswordSecurityController@enable2fa')->name('enable2fa');
    Route::post('/disable2fa','PasswordSecurityController@disable2fa')->name('disable2fa');
    Route::post('/2faVerify', 'PasswordSecurityController@verify2fa')->name('2faVerify')->middleware(['auth', '2fa', 'throttle:15,15']);

});


Route::group(['prefix' => 'admin', 'middleware' => ['auth','2fa','throttle']], function(){     

    Route::middleware(['password_expired'])->group(function () {
        Route::get('/home', 'HomeController@index');
    });

    Route::get('password/expired', 'Auth\ExpiredPasswordController@expired')
        ->name('password.expired');
    Route::post('password/post_expired', 'Auth\ExpiredPasswordController@postExpired')
        ->name('password.post_expired');


    
    Route::resource('users', 'UserController');
    Route::resource('bonds', 'BondController');

    Route::get('api/{type}/{query?}','AdminApi\\AdminApiController@getAllUserRole');
    
Route::resource('bondProcessParams', 'BondProcessParamsController');


Route::resource('bondMaterialRecipes', 'BondMaterialRecipeController');

Route::resource('bondRecipeProductions', 'BondRecipeProductionController');


Route::get('productionPackagings/attachPacking/{id}', 'ProductionPackagingController@attachPacking');
Route::post('productionPackagings/savePacking/{id}', 'ProductionPackagingController@savePacking');
Route::get('productionPackagings/getPacking/{id}', 'ProductionPackagingController@getPacking');
Route::post('productionPackagings/updatePacking/{id}', 'ProductionPackagingController@updatePacking');
Route::post('productionPackagings/deletePacking/{id}', 'ProductionPackagingController@deletePacking');


Route::resource('productionPackagings', 'ProductionPackagingController');

Route::resource('binderCompositions', 'BinderCompositionController');

Route::resource('mouldSettings', 'MouldSettingsController');

Route::get('consumableCategories/view/softdeleted', 'ConsumableCategoryController@indexDeleted');

Route::resource('consumableCategories', 'ConsumableCategoryController');


Route::resource('consumableItems', 'ConsumableItemController');

Route::get('consumableSettings/attachSettings/{id}', 'ConsumableSettingsController@attachSettings');
Route::post('consumableSettings/saveSettings/{id}', 'ConsumableSettingsController@saveSettings');
Route::get('consumableSettings/getSettings/{id}', 'ConsumableSettingsController@getSettings');
Route::post('consumableSettings/updateSettings/{id}', 'ConsumableSettingsController@updateSettings');
Route::post('consumableSettings/deleteSettings/{id}', 'ConsumableSettingsController@deleteSettings');



Route::resource('accountGroups', 'AccountGroupController');

Route::resource('accounts', 'AccountController');

Route::resource('consumableSettings', 'ConsumableSettingsController');

Route::resource('bondDesigns', 'BondDesignController');


Route::resource('entryTypes', 'EntryTypeController');

Route::resource('entries', 'EntryController');

Route::resource('bondInvoices', 'BondInvoiceController');

Route::resource('qualityChecks', 'QualityCheckController');
Route::resource('consumableConsumpations', 'ConsumableConsumpationController');

Route::get('consumableConsumpations/attachConsumpation/{id}', 'ConsumableConsumpationController@attachConsumpation');
Route::post('consumableConsumpations/saveConsumpation/{id}', 'ConsumableConsumpationController@saveConsumpation');
Route::get('consumableConsumpations/getConsumpation/{id}', 'ConsumableConsumpationController@getConsumpation');
Route::post('consumableConsumpations/updateConsumpation/{id}', 'ConsumableConsumpationController@updateConsumpation');
Route::post('consumableConsumpations/deleteConsumpation/{id}', 'ConsumableConsumpationController@deleteConsumpation');

Route::resource('bondProducts', 'BondProductController');
Route::resource('entryTags', 'EntryTagController');

Route::resource('employees', 'EmployeeController');

Route::resource('printerTemplates', 'PrinterTemplateController');

});




