<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use jeremykenedy\LaravelRoles\Traits\HasRoleAndPermission;
use Laravel\Passport\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use InvalidArgumentException;


/**
 * Class User
 * @package App\Models
 * @version October 11, 2019, 4:03 am UTC
 *
 * @property \Illuminate\Database\Eloquent\Collection userRoles
 * @property string name
 * @property string address
 * @property string phone
 * @property string username
 * @property string email
 * @property string password
 * @property string device_id
 * @property string location
 * @property string profile_path
 * @property string dob
 * @property string status
 */
class User extends Authenticatable
{
    //use SoftDeletes;
    use HasRoleAndPermission;
    use HasApiTokens, Notifiable;

    public $table = 'users';
    

    protected $dates = [];


    public $fillable = [
        'name',
        'address',
        'phone',
        'username',
        'email',
        'password',
        'profile_path',
        'dob',
        'status',
        'password_changed_at'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'name' => 'string',
        'address' => 'string',
        'phone' => 'string',
        'username' => 'string',
        'email' => 'string',
        'password' => 'string',
        'device_id' => 'string',
        'location' => 'string',
        'profile_path' => 'string',
        'dob' => 'date',
        'status' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required',
        'username' => 'required|unique:users,username',
        'email' => 'required|email|unique:users,username',
        'password' => 'required|min:6',
        'status' => 'required'
    ];

    public function passwordSecurity()
    {
        return $this->hasOne('App\Models\PasswordSecurity');
    }

    public function rolePermissions()
    {
        $permissionModel = app(config('roles.models.permission'));

        if (!$permissionModel instanceof Model) {
            throw new InvalidArgumentException('[roles.models.permission] must be an instance of \Illuminate\Database\Eloquent\Model');
        }

        return $permissionModel
            ::select(['permissions.*', 'permission_role.created_at as pivot_created_at', 'permission_role.updated_at as pivot_updated_at'])
            ->join('permission_role', 'permission_role.permission_id', '=', 'permissions.id')
            ->join('roles', 'roles.id', '=', 'permission_role.role_id')
            ->whereIn('roles.id', $this->getRoles()->pluck('id')->toArray())
            ->groupBy(['permissions.id', 'permissions.name', 'permissions.slug', 'permissions.description', 'permissions.model', 'permissions.created_at', 'permissions.updated_at', 'permissions.deleted_at', 'pivot_created_at', 'pivot_updated_at']);
    }

}
