<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

/**
 * Class ProductionPackaging
 * @package App\Models
 * @version October 11, 2019, 10:41 pm UTC
 *
 */
class ProductionPackagingDetail extends Model
{
   

    public $table = 'production_packaging_detail';

    
    

    public $fillable = [
        'id',
        'packing_id',
        'material_id',
        'qty',
        'updated_by',
        'created_by'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'qty' => 'float'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'material_id' => 'required|exists:bond_material_recipes',
        'qty' => 'required|numeric',
    ];

    public function material(){
        return $this->belongsTo('App\Models\BondMaterialRecipe','material_id');
    }
    
}
