<?php 

namespace App\Http\Resources\Account;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\BaseJsonResource;

class AccountResource extends BaseJsonResource
{
    public function toArray($request)
    {

        $array = [
            'id' => $this->id,
            'account_group' => new AccountGroupResource($this->group),
            'name' => $this->name,
            'balance_cr' => $this->balance_cr,
            'balance_dr' =>  $this->balance_dr,
            'type' => $this->type,
            'reconciliation' => $this->reconciliation,
            'phoneNo' => $this->phoneNo,
            'gstNo' => $this->gstNo,
            'billing_address' => $this->billing_address,
            'shipping_address' => $this->shipping_address,
            'state' => new StateResource($this->state)
        ];

        $array = $this->base($array);
        
        return $array;
    }
}