<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Entry
 * @package App\Models
 * @version November 26, 2019, 3:52 am UTC
 *
 */
class EntryItem extends Model
{
    

    public $table = 'entryitems';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'entry_id',
        'account_id',
        'cr_total',
        'dr_total',
        'reconciliation_date',        
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'amount' => 'float'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'account_id' => 'required|exists:accounts',
        'amount' => 'required|numeric|gt:0'
    ];

    public function account(){
        return $this->belongsTo('App\Models\Account','account_id');
    }

    public function entry(){
        return $this->belongsTo('App\Models\Entry','entry_id');
    }
}
