<?php 

namespace App\Http\Resources\Mini;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Http\Resources\BaseJsonResource;

class MiniBondProductResource extends BaseJsonResource
{
    public function toArray($request)
    {

        $array = [
            'id' => $this->id,
            'name' => $this->name,
            'bond' => new MiniBondResource($this->bond),
            'design' => new MiniBondDesignResource($this->design),
            'status' => $this->status,
        ];
        
        return $array;
    }
}