<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;

/**
 * Class Entry
 * @package App\Models
 * @version November 26, 2019, 3:52 am UTC
 *
 */
class Entry extends CRUDAwareModel
{
   // use SoftDeletes;

    public $table = 'entries';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'entrytype_id',
        'ref_number',
        'tr_date',
        'invoice_ref_id',
        'cr_total',
        'dr_total',
        'narration', 
        'created_by',
        'updated_by'       
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'blance_cr' => 'float',
        'balance_dr' => 'float'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'entrytype_id' => 'required|unique:entry_types,id',
        'tr_date' => 'required|date|date_format:d-m-Y',
        'cr_total' => 'required|numeric|gt:0',
        'dr_total' => 'required|numeric|gt:0'
    ];

    public function items(){
        return $this->hasMany('App\Models\EntryItem','entry_id');
    }

    public function entryType(){
        return $this->belongsTo('App\Models\EntryType','entrytype_id');
    }
   
    public function invoice(){
        return $this->belongsTo('App\Models\Invoice','invoice_ref_id');
    }

    public function getTrDateAttribute() {
        return Carbon::createFromFormat('Y-m-d', $this->attributes['tr_date'])->format('d-m-Y');
    }
    
    public function setTrDateAttribute($value) {
        $this->attributes['tr_date'] = Carbon::createFromFormat('d-m-Y', $value)->format('Y-m-d');
    }
    
}
