<?php

namespace App\Http\Controllers;

use App\DataTables\MouldSettingsDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateMouldSettingsRequest;
use App\Http\Requests\UpdateMouldSettingsRequest;
use App\Repositories\MouldSettingsRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;

class MouldSettingsController extends AppBaseController
{
    /** @var  MouldSettingsRepository */
    private $mouldSettingsRepository;

    public function __construct(MouldSettingsRepository $mouldSettingsRepo)
    {
        $this->mouldSettingsRepository = $mouldSettingsRepo;
    }

    /**
     * Display a listing of the MouldSettings.
     *
     * @param MouldSettingsDataTable $mouldSettingsDataTable
     * @return Response
     */
    public function index(MouldSettingsDataTable $mouldSettingsDataTable)
    {
        return $mouldSettingsDataTable->render('mould_settings.index');
    }

    /**
     * Show the form for creating a new MouldSettings.
     *
     * @return Response
     */
    public function create()
    {
        return view('mould_settings.create');
    }

    /**
     * Store a newly created MouldSettings in storage.
     *
     * @param CreateMouldSettingsRequest $request
     *
     * @return Response
     */
    public function store(CreateMouldSettingsRequest $request)
    {
        $input = $request->all();

        $mouldSettings = $this->mouldSettingsRepository->create($input);

        Flash::success('Mould Settings saved successfully.');

        return redirect(route('mouldSettings.index'));
    }

    /**
     * Display the specified MouldSettings.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $mouldSettings = $this->mouldSettingsRepository->find($id);

        if (empty($mouldSettings)) {
            Flash::error('Mould Settings not found');

            return redirect(route('mouldSettings.index'));
        }

        return view('mould_settings.show')->with('mouldSettings', $mouldSettings);
    }

    /**
     * Show the form for editing the specified MouldSettings.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $mouldSettings = $this->mouldSettingsRepository->find($id);

        if (empty($mouldSettings)) {
            Flash::error('Mould Settings not found');

            return redirect(route('mouldSettings.index'));
        }

        return view('mould_settings.edit')->with('mouldSettings', $mouldSettings);
    }

    /**
     * Update the specified MouldSettings in storage.
     *
     * @param  int              $id
     * @param UpdateMouldSettingsRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateMouldSettingsRequest $request)
    {
        $mouldSettings = $this->mouldSettingsRepository->find($id);

        if (empty($mouldSettings)) {
            Flash::error('Mould Settings not found');

            return redirect(route('mouldSettings.index'));
        }

        $mouldSettings = $this->mouldSettingsRepository->update($request->all(), $id);

        Flash::success('Mould Settings updated successfully.');

        return redirect(route('mouldSettings.index'));
    }

    /**
     * Remove the specified MouldSettings from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $mouldSettings = $this->mouldSettingsRepository->find($id);

        if (empty($mouldSettings)) {
            Flash::error('Mould Settings not found');

            return redirect(route('mouldSettings.index'));
        }

        $this->mouldSettingsRepository->delete($id);

        Flash::success('Mould Settings deleted successfully.');

        return redirect(route('mouldSettings.index'));
    }
}
