<?php

namespace App\Http\Controllers;

use App\DataTables\BondProcessParamsDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateBondProcessParamsRequest;
use App\Http\Requests\UpdateBondProcessParamsRequest;
use App\Repositories\BondProcessParamsRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;
use Log;
use Carbon\Carbon;

class BondProcessParamsController extends AppBaseController
{
    /** @var  BondProcessParamsRepository */
    private $bondProcessParamsRepository;

    public function __construct(BondProcessParamsRepository $bondProcessParamsRepo)
    {
        $this->bondProcessParamsRepository = $bondProcessParamsRepo;
    }

    /**
     * Display a listing of the BondProcessParams.
     *
     * @param BondProcessParamsDataTable $bondProcessParamsDataTable
     * @return Response
     */
    public function index(BondProcessParamsDataTable $bondProcessParamsDataTable)
    {
        return $bondProcessParamsDataTable->render('bond_process_params.index');
    }

    /**
     * Show the form for creating a new BondProcessParams.
     *
     * @return Response
     */
    public function create()
    {
        return view('bond_process_params.create');
    }

    /**
     * Store a newly created BondProcessParams in storage.
     *
     * @param CreateBondProcessParamsRequest $request
     *
     * @return Response
     */
    public function store(CreateBondProcessParamsRequest $request)
    {
        $input = $request->all();
        //dd($input);  

        $bondProcessParams = $this->bondProcessParamsRepository->create($input);

        $this->attachConsumableSettings($input, $bondProcessParams);

        Flash::success('Bond Process Params saved successfully.');

        return redirect(route('bondProcessParams.index'));
    }

    private function attachConsumableSettings($input, $bondProcessParams){
        $bondProcessParams->consumableSettings()->detach();
        $settingsIDs = array_map('intval', explode(',', $input['consumable_settings']));

        if(!empty($input['consumable_settings'])){
            $bondProcessParams->consumableSettings()->attach($settingsIDs ,['created_at' => Carbon::now()]);
        }
    }

    /**
     * Display the specified BondProcessParams.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $bondProcessParams = $this->bondProcessParamsRepository->find($id);

        if (empty($bondProcessParams)) {
            Flash::error('Bond Process Params not found');

            return redirect(route('bondProcessParams.index'));
        }

        return view('bond_process_params.show')->with('bondProcessParams', $bondProcessParams);
    }

    /**
     * Show the form for editing the specified BondProcessParams.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $bondProcessParams = $this->bondProcessParamsRepository->find($id);

        if (empty($bondProcessParams)) {
            Flash::error('Bond Process Params not found');

            return redirect(route('bondProcessParams.index'));
        }

        return view('bond_process_params.edit')->with('bondProcessParams', $bondProcessParams);
    }

    /**
     * Update the specified BondProcessParams in storage.
     *
     * @param  int              $id
     * @param UpdateBondProcessParamsRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateBondProcessParamsRequest $request)
    {
        $input = $request->all();
        
        $bondProcessParams = $this->bondProcessParamsRepository->find($id);

        if (empty($bondProcessParams)) {
            Flash::error('Bond Process Params not found');

            return redirect(route('bondProcessParams.index'));
        }

        $bondProcessParams = $this->bondProcessParamsRepository->update($request->all(), $id);

        $this->attachConsumableSettings($input, $bondProcessParams);

        Flash::success('Bond Process Params updated successfully.');

        return redirect(route('bondProcessParams.index'));
    }

    /**
     * Remove the specified BondProcessParams from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $bondProcessParams = $this->bondProcessParamsRepository->find($id);

        if (empty($bondProcessParams)) {
            Flash::error('Bond Process Params not found');

            return redirect(route('bondProcessParams.index'));
        }

        $this->bondProcessParamsRepository->forceDelete($id);

        Flash::success('Bond Process Params deleted successfully.');

        return redirect(route('bondProcessParams.index'));
    }
}
