<?php

namespace App\Http\Controllers\API;

use App\Http\Requests\API\CreateBinderCompositionAPIRequest;
use App\Http\Requests\API\UpdateBinderCompositionAPIRequest;
use App\Models\BinderComposition;
use App\Repositories\BinderCompositionRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\AppBaseController;
use Response;

/**
 * Class BinderCompositionController
 * @package App\Http\Controllers\API
 */

class BinderCompositionAPIController extends AppBaseController
{
    /** @var  BinderCompositionRepository */
    private $binderCompositionRepository;

    public function __construct(BinderCompositionRepository $binderCompositionRepo)
    {
        $this->binderCompositionRepository = $binderCompositionRepo;
    }

    /**
     * Display a listing of the BinderComposition.
     * GET|HEAD /binderCompositions
     *
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $binderCompositions = $this->binderCompositionRepository->all(
            $request->except(['skip', 'limit']),
            $request->get('skip'),
            $request->get('limit')
        );

        return $this->sendResponse($binderCompositions->toArray(), 'Binder Compositions retrieved successfully');
    }

    /**
     * Store a newly created BinderComposition in storage.
     * POST /binderCompositions
     *
     * @param CreateBinderCompositionAPIRequest $request
     *
     * @return Response
     */
    public function store(CreateBinderCompositionAPIRequest $request)
    {
        $input = $request->all();

        $binderComposition = $this->binderCompositionRepository->create($input);

        return $this->sendResponse($binderComposition->toArray(), 'Binder Composition saved successfully');
    }

    /**
     * Display the specified BinderComposition.
     * GET|HEAD /binderCompositions/{id}
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var BinderComposition $binderComposition */
        $binderComposition = $this->binderCompositionRepository->find($id);

        if (empty($binderComposition)) {
            return $this->sendError('Binder Composition not found');
        }

        return $this->sendResponse($binderComposition->toArray(), 'Binder Composition retrieved successfully');
    }

    /**
     * Update the specified BinderComposition in storage.
     * PUT/PATCH /binderCompositions/{id}
     *
     * @param int $id
     * @param UpdateBinderCompositionAPIRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateBinderCompositionAPIRequest $request)
    {
        $input = $request->all();

        /** @var BinderComposition $binderComposition */
        $binderComposition = $this->binderCompositionRepository->find($id);

        if (empty($binderComposition)) {
            return $this->sendError('Binder Composition not found');
        }

        $binderComposition = $this->binderCompositionRepository->update($input, $id);

        return $this->sendResponse($binderComposition->toArray(), 'BinderComposition updated successfully');
    }

    /**
     * Remove the specified BinderComposition from storage.
     * DELETE /binderCompositions/{id}
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var BinderComposition $binderComposition */
        $binderComposition = $this->binderCompositionRepository->find($id);

        if (empty($binderComposition)) {
            return $this->sendError('Binder Composition not found');
        }

        $binderComposition->delete();

        return $this->sendResponse($id, 'Binder Composition deleted successfully');
    }
}
